#include "General.h"
#include "HideCommands.h"
#include "Tokenizer.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "gmlog.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

HashTemplateClass<StringClass, int> CommandsHideList;

void Load_Commands_To_Hide(INIClass* SSGMIni)
{	
	int Count = SSGMIni->Entry_Count("HideCommands");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("HideCommands", i);
		CommandsHideList.Insert(Entry, 1);
	}

	//DEBUG CRAP
/*	for (HashTemplateIterator<StringClass, int> iter(CommandsHideList); iter; ++iter)
	{
		Console_Output("%s\n", iter.getKey());
	} */
}

HideCommands::HideCommands()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

HideCommands::~HideCommands()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
}

void HideCommands::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	Load_Commands_To_Hide(SSGMIni);
}

bool HideCommands::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		Tokenizer Tokens = Tokenizer(StringClass(Message));

		if (CommandsHideList.Exists(Tokens[1]))
		{
			char type[8];
			if (Type ==	0)
			{
				sprintf(type,"PUBLIC");
			}
			else if (Type == 1)
			{
				sprintf(type,"TEAM");
			}

			SSGMGameLog::Log_RenLog(TT_FORMAT(1024, "%s %S: %S", Type ? "[Team]" : "", Find_Player(PlayerID)->PlayerName, Message)); 
//		SSGMGameLog::Log_Gamelog(TT_FORMAT(1024, "CHAT;%s;%d;%ls", type, Commands->Get_ID(Get_GameObj(PlayerID)), Message)); 
			return false;
		}
	}

	return true;
}

HideCommands hideCommands;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &hideCommands;
}
